C*  GENERAL CONFORMAL MAP ROUTINES FOR METEOROLOGICAL MODELERS
C*  WRITTEN ON 3/31/94 BY

C* Dr. Albion Taylor
C* NOAA / OAR / ARL                  Phone: (301) 713-0295 x 132
C* Rm. 3151, 1315 East-West Highway  Fax:   (301) 713-0119
C* Silver Spring, MD 20910           E-mail: ADTaylor@arlrisc.ssmc.noaa.gov 

C*  SUBROUTINE STLMBR (STCPRM, TNGLAT, CLONG)
C*    THIS ROUTINE INITIALIZES THE MAP STRUCTURE ARRAY STCPRM TO
C*    THE FORM OF A SPECIFIC MAP PROJECTION
C*  INPUTS:
C*    TNGLAT - THE LATITUDE AT WHICH THE PROJECTION WILL BE TANGENT
C*             TO THE EARTH.  +90. FOR NORTH POLAR STEREOGRAPHIC,
C*             -90. FOR SOUTH POLAR STEREOGRAPHIC, 0. FOR MERCATOR,
C*             AND OTHER VALUES FOR LAMBERT CONFORMAL. 
C*             -90 <= TNGLAT <= 90.
C*    CLONG -  A LONGITUDE IN THE REGION UNDER CONSIDERATION.  LONGITUDES
C*             BETWEEN CLONG-180. AND CLONG+180.  WILL BE MAPPED IN ONE
C*             CONNECTED REGION
C*  OUTPUTS:
C*    STCPRM - A 9-VALUE MAP STRUCTURE ARRAY FOR USE WITH SUBSEQUENT
C*             CALLS TO THE COORDINATE TRANSFORM ROUTINES.
C*
C*  REAL FUNCTION EQVLAT (XLAT1,XLAT2)
C*    THIS FUNCTION IS PROVIDED TO ASSIST IN FINDING THE TANGENT LATITUDE
C*    EQUIVALENT TO THE 2-REFERENCE LATITUDE SPECIFICATION IN THE LEGEND
C*    OF MOST LAMBERT CONFORMAL MAPS.  IF THE MAP SPECIFIES "SCALE 
C*    1:XXXXX TRUE AT 40N AND 60N", THEN EQVLAT(40.,60.) WILL RETURN THE
C*    EQUIVALENT TANGENT LATITUDE.
C*  INPUTS:
C*    XLAT1,XLAT2:  THE TWO LATITUDES SPECIFIED IN THE MAP LEGEND
C*  RETURNS:
C*    THE EQUIVALENT TANGENT LATITUDE
C*  EXAMPLE:  CALL STLMBR(STCPRM, EQVLAT(40.,60.), 90.)

C*  SUBROUTINE STCM2P (STCPRM, X1,Y1, XLAT1,XLONG1,
C*          X2,Y2, XLAT2,XLONG2)
C*  SUBROUTINE STCM1P (STCPRM, X1,Y1, XLAT1,XLONG1,
C*          XLATG,XLONGG, GRIDSZ, ORIENT)
C*    THESE ROUTINES COMPLETE THE SPECIFICATION OF THE MAP STRUCTURE
C*    ARRAY BY CONFORMING THE MAP COORDINATES TO THE SPECIFICATIONS
C*    OF A PARTICULAR GRID.  EITHER STCM1P OR STCM2P MUST BE CALLED,
C*    BUT NOT BOTH
C*  INPUTS:
C*    STCPRM - A 9-VALUE MAP STRUCTURE ARRAY, SET TO A PARTICULAR MAP
C*             FORM BY A PREVIOUS CALL TO STLMBR
C*    FOR STCM2P:
C*      X1,Y1, X2,Y2 - THE MAP COORDINATES OF TWO POINTS ON THE GRID
C*      XLAT1,XLONG1, XLAT2,XLONG2 - THE GEOGRAPHIC COORDINATES OF THE
C*             SAME TWO POINTS
C*    FOR STCM1P:
C*      X1,Y1 - THE MAP COORDINATES OF ONE POINT ON THE GRID
C*      XLAT1,XLONG1 - THE GEOGRAPHIC COORDINATES OF THE SAME POINT
C*      XLATG,XLONGG - LATITUDE AND LONGITUDE OF REFERENCE POINT FOR
C*             GRIDSZ AND ORIENTATION SPECIFICATION.
C*      GRIDSZ - THE DESIRED GRID SIZE IN KILOMETERS, AT XLATG,XLONGG
C*      ORIENT - THE ANGLE, WITH RESPECT TO NORTH, OF A Y-GRID LINE, AT
C*             THE POINT XLATG,XLONGG
C*  OUTPUTS:
C*    STCPRM - A 9-VALUE MAP STRUCTURE ARRAY, FULLY SET FOR USE BY
C*             OTHER SUBROUTINES IN THIS SYSTEM

C*  SUBROUTINE CLL2XY (STCPRM, XLAT,XLONG, X,Y)
C*  SUBROUTINE CXY2LL (STCPRM, X,Y, XLAT,XLONG)
C*     THESE ROUTINES CONVERT BETWEEN MAP COORDINATES X,Y
C*     AND GEOGRAPHIC COORDINATES XLAT,XLONG
C*  INPUTS:
C*     STCPRM(9) - 9-VALUE MAP STRUCTURE ARRAY
C*     FOR CLL2XY:  XLAT,XLONG - GEOGRAPHIC COORDINATES
C*     FOR CXY2LL:  X,Y - MAP COORDINATES
C*  OUTPUTS:
C*     FOR CLL2XY:  X,Y - MAP COORDINATES
C*     FOR CXY2LL:  XLAT,XLONG - GEOGRAPHIC COORDINATES

C*  SUBROUTINE CC2GXY (STCPRM, X,Y, UE,VN, UG,VG)
C*  SUBROUTINE CG2CXY (STCPRM, X,Y, UG,VG, UE,VN)
C*  SUBROUTINE CC2GLL (STCPRM, XLAT,XLONG, UE,VN, UG,VG)
C*  SUBROUTINE CG2CLL (STCPRM, XLAT,XLONG, UG,VG, UE,VN)
C*     THESE SUBROUTINES CONVERT VECTOR WIND COMPONENTS FROM
C*     GEOGRAPHIC, OR COMPASS, COORDINATES, TO MAP OR
C*     GRID COORDINATES.  THE SITE OF THE WIND TO BE
C*     CONVERTED MAY BE GIVEN EITHER IN GEOGRAPHIC OR
C*     MAP COORDINATES.  WIND COMPONENTS ARE ALL IN KILOMETERS
C*     PER HOUR, WHETHER GEOGRAPHIC OR MAP COORDINATES.
C*  INPUTS:
C*    STCPRM(9) - 9-VALUE MAP STRUCTURE ARRAY
C*    FOR CC2GXY AND CG2CXY:  X,Y        -  MAP COORDINATES OF SITE
C*    FOR CC2GLL AND CG2CLL:  XLAT,XLONG -  GEOGRAPHIC COORDINATES OF SITE
C*    FOR CC2GXY AND CC2GLL:  UE,VN - EAST AND NORTH WIND COMPONENTS
C*    FOR CG2CXY AND CG2CLL:  UG,VG - X- AND Y- DIRECTION WIND COMPONENTS
C*  OUTPUTS:
C*    FOR CC2GXY AND CC2GLL:  UG,VG - X- AND Y- DIRECTION WIND COMPONENTS
C*    FOR CG2CXY AND CG2CLL:  UE,VN - EAST AND NORTH WIND COMPONENTS
C*  3/9/99 CHANGES MADE IN THE C C2G AND G2C ROUTINES TO ALLOW UG,VG AND UE,VN TO
C* SHARE THE SAME STORAGE BEFORE AND AFTER BEING CALLED
C*  SUBROUTINE CCRVXY (STCPRM, X, Y,       GX,GY)
C*  SUBROUTINE CCRVLL (STCPRM, XLAT,XLONG, GX,GY)
C*    THESE SUBROUTINES RETURN THE CURVATURE VECTOR (GX,GY), AS REFERENCED
C*    TO MAP COORDINATES, INDUCED BY THE MAP TRANSFORMATION.  WHEN
C*    NON-LINEAR TERMS IN WIND SPEED ARE IMPORTANT, A "GEODESIC" FORCE
C*    SHOULD BE INCLUDED IN THE VECTOR FORM [ (U,U) G - (U,G) U ] WHERE THE
C*    INNER PRODUCT (U,G) IS DEFINED AS UX*GX + UY*GY.
C*  INPUTS:
C*    STCPRM(9) - 9-VALUE MAP STRUCTURE ARRAY
C*    FOR CCRVXY:  X,Y        -  MAP COORDINATES OF SITE
C*    FOR CCRVLL:  XLAT,XLONG -  GEOGRAPHIC COORDINATES OF SITE
C*  OUTPUTS:
C*    GX,GY       - VECTOR COEFFICIENTS OF CURVATURE, IN UNITS RADIANS
C*                  PER KILOMETER

C*  REAL FUNCTION CGSZLL (STCPRM, XLAT,XLONG)
C*  REAL FUNCTION CGSZXY (STCPRM, X,Y)
C*    THESE FUNCTIONS RETURN THE SIZE, IN KILOMETERS, OF EACH UNIT OF
C*    MOTION IN MAP COORDINATES (GRID SIZE).  THE GRID SIZE AT ANY
C*    LOCATION DEPENDS ON THAT LOCATION; THE POSITION MAY BE GIVEN IN
C*    EITHER MAP OR GEOGRAPHIC COORDINATES.
C*  INPUTS:
C*    STCPRM(9) - 9-VALUE MAP STRUCTURE ARRAY
C*    FOR CGSZXY:  X,Y        -  MAP COORDINATES OF SITE
C*    FOR CGSZLL:  XLAT,XLONG -  GEOGRAPHIC COORDINATES OF SITE
C*  RETURNS:
C*    GRIDSIZE IN KILOMETERS AT GIVEN SITE.

C*  SUBROUTINE CPOLXY (STCPRM, X,Y, ENX,ENY,ENZ)
C*  SUBROUTINE CPOLLL (STCPRM, XLAT,XLONG, ENX,ENY,ENZ)
C*    THESE SUBROUTINES PROVIDE 3-D VECTOR COMPONENTS OF A UNIT VECTOR
C*    IN THE DIRECTION OF THE NORTH POLAR AXIS.  WHEN MULTIPLIED
C*    BY TWICE THE ROTATION RATE OF THE EARTH (2 * PI/24 HR), THE
C*    VERTICAL COMPONENT YIELDS THE CORIOLIS FACTOR.
C*  INPUTS:
C*    STCPRM(9) - 9-VALUE MAP STRUCTURE ARRAY
C*    FOR CPOLXY:  X,Y        -  MAP COORDINATES OF SITE
C*    FOR CPOLLL:  XLAT,XLONG -  GEOGRAPHIC COORDINATES OF SITE
C*  RETURNS:
C*    ENX,ENY,ENZ THE DIRECTION COSINES OF A UNIT VECTOR IN THE
C*    DIRECTION OF THE ROTATION AXIS OF THE EARTH

C*  SUBROUTINE CNLLXY (STCPRM, XLAT,XLONG, XI,ETA)
C*  SUBROUTINE CNXYLL (STCPRM, XI,ETA, XLAT,XLONG)
C*    THESE SUBROUTINES PERFORM THE UNDERLYING TRANSFORMATIONS FROM
C*    GEOGRAPHIC COORDINATES TO AND FROM CANONICAL (EQUATOR CENTERED)
C*    COORDINATES.  THEY ARE CALLED BY CXY2LL AND CLL2XY, BUT ARE NOT
C*    INTENDED TO BE CALLED DIRECTLY

C*  REAL FUNCTION CSPANF (VALUE, BEGIN, END)
C*    THIS FUNCTION ASSISTS OTHER ROUTINES IN PROVIDING A LONGITUDE IN
C*    THE PROPER RANGE.  IT ADDS TO VALUE WHATEVER MULTIPLE OF 
C*    (END - BEGIN) IS NEEDED TO RETURN A NUMBER BEGIN < CSPANF <= END

      SUBROUTINE STLMBR(STCPRM, TNGLAT, XLONG)
C*  WRITTEN ON 3/31/94 BY Dr. Albion Taylor  NOAA / OAR / ARL

      include 'cmapf.fi'
      REAL STCPRM(k_maparam)
      STCPRM(k_gama) = SIN(RADPDG * TNGLAT)
C*  GAMMA = SINE OF THE TANGENT LATITUDE
      STCPRM(k_reflon) = CSPANF( XLONG, -180., +180.)
C* LAMBDA_0 = REFERENCE LONGITUDE
      STCPRM(k_x0) = 0.
C* X_0 = X- GRID COORDINATE OF ORIGIN (XI,ETA) = (0.,0.)
      STCPRM(k_y0) = 0.
C* y_0 = Y-GRID COORDINATE OF ORIGIN (XI,ETA) = (0.,0.)
      STCPRM(k_crot) = 1.
C* COSINE OF ROTATION ANGLE FROM XI,ETA TO X,Y
      STCPRM(k_srot) = 0.
C* SINE OF ROTATION ANGLE FROM XI,ETA TO X,Y
      STCPRM(k_gdszeq) = REARTH
C* GRIDSIZE IN KILOMETERS AT THE EQUATOR
      CALL CNLLXY(STCPRM, 88.9,XLONG, XI,ETA)
      STCPRM(k_n1dgr) = 2. * ETA - STCPRM(k_gama) * ETA * ETA
C* RADIAL COORDINATE FOR 1 DEGREE FROM NORTH POLE
      CALL CNLLXY(STCPRM, -88.9,XLONG, XI,ETA)
   	STCPRM(k_s1dgr) = 2. * ETA - STCPRM(k_gama) * ETA * ETA
C* RADIAL COORDINATE FOR 1 DEGREE FROM SOUTH POLE
      RETURN
      END
