
	REAL FUNCTION CSPANF (VALUE, BEGIN, END)
C*  WRITTEN ON 3/31/94 BY Dr. Albion Taylor  NOAA / OAR / ARL
C* REAL FUNCTION CSPANF RETURNS A VALUE IN THE INTERVAL (BEGIN,END]
C* WHICH IS EQUIVALENT TO VALUE, MOD (END - BEGIN).  IT IS USED TO
C* REDUCE PERIODIC VARIABLES TO A STANDARD RANGE.  IT ADJUSTS FOR THE
C* BEHAVIOR OF THE MOD FUNCTION WHICH PROVIDES POSITIVE RESULTS FOR
c* POSITIVE INPUT, AND NEGATIVE RESULTS FOR NEGATIVE INPUT
C* INPUT:
C*       VALUE - REAL NUMBER TO BE REDUCED TO THE SPAN
C*       BEGIN - FIRST VALUE OF THE SPAN
C*       END   - LAST VALUE OF THE SPAN
C* RETURNS:
C*       THE REDUCED VALUE
C* EXAMPLES:
C*      ALONG = CSPANF(XLONG, -180., +180.)
C*      DIR  = CSPANF(ANGLE, 0., 360.)
	REAL FIRST,LAST
	FIRST = MIN(BEGIN,END)
	LAST = MAX(BEGIN,END)
	VAL = MOD( VALUE - FIRST , LAST - FIRST)
	IF ( VAL . LE. 0.) THEN
	  CSPANF = VAL + LAST
	ELSE
	  CSPANF = VAL + FIRST
	ENDIF
	RETURN
	END
