      SUBROUTINE CNLLXY (STCPRM, XLAT,XLONG, XI,ETA)
C*  WRITTEN ON 3/31/94 BY Dr. Albion Taylor  NOAA / OAR / ARL
C  MAIN TRANSFORMATION ROUTINE FROM LATITUDE-LONGITUDE TO
C  CANONICAL (EQUATOR-CENTERED, RADIAN UNIT) COORDINATES
      PARAMETER (ALMST1=.99999)
      include 'cmapf.fi'
      real stcprm(k_maparam)
      DOUBLE PRECISION GAMMA
      DOUBLE PRECISION DLONG,DLAT,SLAT,MERCY,GMERCY
      GAMMA = STCPRM(k_gama)
      DLAT = XLAT
      DLONG = CSPANF(XLONG - STCPRM(k_reflon), -180., 180.)
      DLONG = DLONG * RADPDG
      GDLONG = GAMMA * DLONG
      IF (ABS(GDLONG) .LT. .01) THEN
C  CODE FOR GAMMA SMALL OR ZERO.  THIS AVOIDS ROUND-OFF ERROR OR DIVIDE-
C  BY ZERO IN THE CASE OF MERCATOR OR NEAR-MERCATOR PROJECTIONS.
        GDLONG = GDLONG * GDLONG
        SNDGAM = DLONG * (1. - 1./6. * GDLONG *
     C			   (1. - 1./20. * GDLONG *
     C			   (1. - 1./42. * GDLONG )))
        CSDGAM = DLONG * DLONG * .5 *
     C			   (1. - 1./12. * GDLONG *
     C			   (1. - 1./30. * GDLONG *
     C			   (1. - 1./56. * GDLONG )))
      ELSE
C CODE FOR MODERATE VALUES OF GAMMA
        SNDGAM = SIN (GDLONG) /GAMMA
        CSDGAM = (1. - COS(GDLONG) )/GAMMA /GAMMA
      ENDIF
      SLAT = SIN(RADPDG * DLAT)
      IF ((SLAT .GE. ALMST1) .OR. (SLAT .LE. -ALMST1)) THEN
        ETA = 1./STCPRM(k_gama)
        XI = 0.
        RETURN
      ENDIF
      MERCY = .5 * LOG( (1. + SLAT) / (1. - SLAT) )
      GMERCY = GAMMA * MERCY
      IF (ABS(GMERCY) .LT. .001) THEN
C  CODE FOR GAMMA SMALL OR ZERO.  THIS AVOIDS ROUND-OFF ERROR OR DIVIDE-
C  BY ZERO IN THE CASE OF MERCATOR OR NEAR-MERCATOR PROJECTIONS.
        RHOG1 = MERCY * (1. - .5 * GMERCY *
     C			  (1. - 1./3. * GMERCY *
     C			  (1. - 1./4. * GMERCY ) ) )
      ELSE
C CODE FOR MODERATE VALUES OF GAMMA
        RHOG1 = (1. - EXP(-GMERCY)) / GAMMA
      ENDIF
      ETA = RHOG1 + (1. - GAMMA * RHOG1) * GAMMA * CSDGAM
      XI = (1. - GAMMA * RHOG1 ) * SNDGAM
      END
