#include "cmapf.h"

void printmp(maparam * stcprm){
printf("gamma    = %f, ",stcprm->gamma);
printf("reflon   = %f\n",stcprm->reflon);
printf("x0       = %f, ",stcprm->x0);
printf("y0       = %f\n",stcprm->y0);
printf("crotate  = %f, ",stcprm->crotate);
printf("srotate  = %f, ",stcprm->srotate);
printf("gridszeq = %f\n",stcprm->gridszeq);
printf("npwarn   = %f, ",stcprm->npwarn);
printf("spwarn   = %f\n",stcprm->spwarn);
}

int main(){
double reflon= -70.;
double reflat1=40., reflat2=60.,gridlat=30.;
double ue = 30.,vn = 40.;
double ug,vg,ue1,vn1;
double enx,eny,enz;
maparam stcprm;
double lat,longit,x,y,lat2,longit2;
  printf("%f \n",eqvlat(reflat1,reflat2));
  stlmbr(& stcprm, eqvlat(reflat1,reflat2), reflon);
/*  stlmbr(& stcprm, 90., reflon);
  stlmbr(& stcprm, 0., reflon); */
  stlmbr(& stcprm,30.,-80.);
  stcm2p(& stcprm, 1.,1., 24.,-86., 11.,6., 42., -71.5);
  printmp(& stcprm);
  printf("Grid size @ %2.0f is %f\n",gridlat,
     cgszll(&stcprm, gridlat, reflon) );
  for (lat=0.;lat <=90.; lat+=10.) {
    for (longit=-87.; longit <= -85.; longit +=1.) {
      printf("-----------------------------------------\n");
      cll2xy(&stcprm, lat,longit, &x,&y);
      printf("From lat,long= (%f,%f) ", lat,longit);
      printf("to x,y = (%f,%f)\n", x,y); 
      cxy2ll(&stcprm, x,y, &lat2,&longit2);
      printf("From x,y = (%f,%f) ", x,y);
      printf("To lat,long= (%f,%f)\n", lat2,longit2);
      printf("Gridsize (ll) = %f, ",cgszll(&stcprm,lat,longit));
      printf("Gridsize (xy) = %f\n",cgszxy(&stcprm,x,y));
      cpolxy(&stcprm, x,y, &enx,&eny,&enz);
      printf("x,y polar vector (nx,ny,nz)=(%f,%f,%f)\n",enx,eny,enz);
      cpolll(&stcprm, lat,longit, &enx,&eny,&enz);
      printf("lat,long polar vector (nx,ny,nz)=(%f,%f,%f)\n",enx,eny,enz);
      ccrvll(&stcprm, lat,longit, &enx,&eny);
      printf("lat,long curvature vector (gx,gy)=(%f,%f)\n",enx,eny);
      ccrvxy(&stcprm, x,y, &enx,&eny);
      printf("x,y curvature vector (gx,gy)=(%f,%f)\n",enx,eny);
      cc2gll(&stcprm, lat,longit, ue,vn, &ug,&vg);
      printf("lat-long winds from ue,vn=(%f,%f) to ug,vg=(%f,%f)\n",
	 ue,vn,ug,vg);
      cg2cll(&stcprm, lat,longit, ug,vg, &ue1,&vn1);
      printf("lat-long winds from ug,vg=(%f,%f) to ue,vn=(%f,%f)\n",
	 ug,vg,ue1,vn1);
      cc2gxy(&stcprm, x,y, ue,vn, &ug,&vg);
      printf("x,y -  winds from ue,vn=(%f,%f) to ug,vg=(%f,%f)\n",
	 ue,vn,ug,vg);
      cg2cxy(&stcprm, x,y, ug,vg, &ue1,&vn1);
      printf("x,y -  winds from ug,vg=(%f,%f) to ue,vn=(%f,%f)\n",
	 ug,vg,ue1,vn1);
    }
  }
  return 0;
}
