#ifndef _CMAPF_H
#define _CMAPF_H
#include <math.h>
#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif
#include <float.h>
/*
 * cmapf.h  - header file for conformal mapping function utility.
 * Written 12/21/94 by
 * Dr. Albion Taylor
 * NOAA / OAR / ARL                  Phone: (301) 713-0295 ext 132
 * Rm. 3151, 1315 East-West Highway  Fax:   (301) 713-0119
 * Silver Spring, MD 20910           E-mail: ADTaylor@arlrisc.ssmc.noaa.gov
 */
typedef struct {
double gamma,reflon,
 x0,y0, crotate,srotate,gridszeq,
 npwarn,spwarn;
} maparam;
#define REARTH 6367.47
/*  REARTH=6356.766  from U.S. Standard Atmosphere, 1976
 *  REARTH=6367.47   for spherical earths in GRIB grids
 *  REARTH=6371.2    original assumption for CMAPF routines.
 *                   source lost, probably old NWPC grids.
 */
#define RADPDEG (M_PI/180.)
#define DEGPRAD (180./M_PI)
void stlmbr(maparam * strcmp,double tnglat,double reflon) ;
void stcm2p(maparam * strcmp,
	    double x1, double y1, double xlat1, double xlong1,
	    double x2, double y2, double xlat2, double xlong2) ;
void stcm1p(maparam * strcmp,
	    double x1, double y1, double xlat1, double xlong1,
	    double xlatg, double xlong, double gridsz, double orient) ;

void cll2xy(maparam * strcmp,double lat,double longit,
		double * x,double * y) ;
void ccrvll(maparam * strcmp,double lat, double longit,
			     double * gx, double * gy) ;
void cxy2ll(maparam * strcmp,double x, double y,
		double * lat, double * longit) ;
void ccrvxy(maparam * strcmp,double x, double y,
			     double * gx, double * gy) ;

void cc2gll(maparam * strcmp,double lat,double longit,
            double ue,double vn, double * ug,double * vg) ;
void cg2cll(maparam * strcmp,double lat,double longit,
            double ug,double vg, double * ue,double * vn) ;
void cc2gxy(maparam * strcmp,double x,double y,
	    double ue,double vn, double * ug,double * vg) ;
void cg2cxy(maparam * strcmp,double x,double y,
	    double ug,double vg, double * ue,double * vn) ;

void cw2gll(maparam * strcmp,double lat,double longit,
            double ue,double vn, double * ug,double * vg) ;
void cg2wll(maparam * strcmp,double lat,double longit,
            double ug,double vg, double * ue,double * vn) ;
void cw2gxy(maparam * strcmp,double x,double y,
	    double ue,double vn, double * ug,double * vg) ;
void cg2wxy(maparam * strcmp,double x,double y,
	    double ug,double vg, double * ue,double * vn) ;

double log1pabovera(double a,double b) ;
double cperiodic(double value,double begin,double end) ;
double eqvlat(double lat1,double lat2) ;

double cgszll(maparam * strcmp,double lat,double longit) ;
double cgszxy(maparam * strcmp,double x,double y) ;

void cpolll(maparam * strcmp,double lat, double longit,
		double * enx,double * eny, double * enz) ;
void cpolxy(maparam * strcmp,double x, double y,
		double * enx,double * eny, double * enz) ;
#endif /*_CMAPF_H*/      
