#include <stdlib.h>
#include <math.h>
#include "cmapf.h"

/*
 * cgszxy.c  - source file for conformal mapping function utility.
 * Written 12/21/94 by
 * Dr. Albion Taylor
 * NOAA / OAR / ARL                  Phone: (301) 713-0295 ext 132
 * Rm. 3151, 1315 East-West Highway  Fax:   (301) 713-0119
 * Silver Spring, MD 20910           E-mail: ADTaylor@arlrisc.ssmc.noaa.gov
 */

double cgszxy(maparam * stcprm,double x,double y) {
double xi,eta,xi0,eta0,ymerc,efact,clat;
#define NEARONE .9999999999999
double radial;
  xi0 = (x - stcprm->x0) * stcprm->gridszeq / REARTH;
  eta0 = (y - stcprm->y0) * stcprm->gridszeq / REARTH;
  xi = xi0 * stcprm->crotate - eta0 * stcprm->srotate;
  eta = xi0 * stcprm->srotate + eta0 * stcprm->crotate;
  radial = 2. * eta - stcprm->gamma * (xi*xi + eta*eta);
  if ((NEARONE - stcprm->gamma * radial) <= 0.) {
    if ( (stcprm->gamma<0 ? -stcprm->gamma: stcprm->gamma)
	   >= NEARONE) return 2. * stcprm->gridszeq;
    return 0.;
  }
  ymerc = .5 * log1pabovera(- stcprm->gamma,radial);
  if (ymerc >  15.)
     return stcprm->gamma > NEARONE ? 2.*stcprm->gridszeq : 0. ;
  if (ymerc <  -15.)
     return stcprm->gamma < -NEARONE ? 2.*stcprm->gridszeq : 0. ;
  efact = exp(ymerc); clat = 2./(efact + 1./efact);
  return stcprm->gridszeq * exp(stcprm->gamma * ymerc) * clat;
#undef NEARONE
}
