#include <stdlib.h>
#include <math.h>
#include "cmapf.h"

/*
 * cgszll.c  - source file for conformal mapping function utility.
 * Written 12/21/94 by
 * Dr. Albion Taylor
 * NOAA / OAR / ARL                  Phone: (301) 713-0295 ext 132
 * Rm. 3151, 1315 East-West Highway  Fax:   (301) 713-0119
 * Silver Spring, MD 20910           E-mail: ADTaylor@arlrisc.ssmc.noaa.gov
 */

double cgszll(maparam * stcprm,double lat,double longit) {
#define NEARONE .9999999999999
double slat = sin(RADPDEG * lat);
double clat,ymerc;
  if (slat <= -1.)
    return (stcprm->gamma < -NEARONE ? 2. * stcprm->gridszeq : 0.);
  if (slat >= 1.)
    return (stcprm->gamma > NEARONE ? 2. * stcprm->gridszeq : 0.);
  clat = cos(RADPDEG * lat);clat = clat<0. ? -clat : clat;
  ymerc = .5 * log((1. + slat) / (1. - slat));
  return stcprm->gridszeq * exp(stcprm->gamma * ymerc) * clat;
  #undef NEARONE
}

