#include <stdlib.h>
#include <math.h>
#include "cmapf.h"

/*
 * ccurv.c  - source file for conformal mapping function utility.
 * Written 12/21/94 by
 * Dr. Albion Taylor
 * NOAA / OAR / ARL                  Phone: (301) 713-0295 ext 132
 * Rm. 3151, 1315 East-West Highway  Fax:   (301) 713-0119
 * Silver Spring, MD 20910           E-mail: ADTaylor@arlrisc.ssmc.noaa.gov
 */

static double cspanf(double value,double begin,double end);
void ccrvll(maparam * stcprm,double lat, double longit,
			     double * gx, double * gy) {
double along = cspanf(longit - stcprm->reflon,-180.,180.)
		   * RADPDEG * stcprm->gamma;
double slong,clong,xpolg,ypolg,curv;
  slong = sin(along);
  clong = cos(along);
  xpolg = -slong * stcprm->crotate + clong * stcprm->srotate;
  ypolg = clong * stcprm->crotate + slong * stcprm->srotate;
  curv = (stcprm->gamma - sin(RADPDEG * lat)) / cos(RADPDEG * lat) /
					REARTH;
  *gx = curv * xpolg;
  *gy = curv * ypolg;
}

void ccrvxy(maparam * stcprm,double x,double y,
			     double * gx, double * gy) {
double temp = stcprm->gamma * stcprm->gridszeq / REARTH;
double xpolg,ypolg;
  xpolg = stcprm->srotate + temp * (stcprm->x0 - x);
  ypolg = stcprm->crotate + temp * (stcprm->y0 - y);
  temp = sqrt(xpolg*xpolg + ypolg * ypolg);
  if(temp > 0.) {
    double ymerc = -log(temp)/stcprm->gamma;
    double efact = exp(ymerc);
    double curv = .5 /REARTH * ((stcprm->gamma - 1.) * efact +
				(stcprm->gamma + 1.) / efact );
    *gx = xpolg * curv / temp;
    *gy = ypolg * curv / temp;
  } else {
    if (stcprm -> gamma == 1. || stcprm->gamma == -1.) {
      *gx = *gy = 0.;
    } else {
      *gx = *gy = 1. / REARTH;
    }
  }
}
static double cspanf(double value,double begin,double end){
double first,last;
first = begin<end?begin:end;
last = begin<end?end:begin;
value = fmod(value-first,last-first);
return value<0 ? value + last : value + first;
}
